from visual import *

scene.title="Configuration"
scene.width=600
scene.height=600

R = 0.01

s_theta=sphere(pos=(0,-1,-1), radius=0.1, color=(0.6, 1.0, 0.6))
s_length=sphere(pos=(0,-1,1), radius=0.1, color=(0.6, 0.6, 1.0))

fixlength = 0
fixtheta = 0

avector = vector (0,0,-.8)
bvector = vector (0,.717,.717)

a = arrow(pos=(0,0,0), axis=avector, shaftwidth=R, color=crayola.red)
b = arrow(pos=(0,0,0), axis=bvector, shaftwidth=R, color=crayola.green)

cvector = cross(avector,bvector)
c = arrow(pos=(0,0,0), axis=cvector, shaftwidth=R, color=crayola.yellow)

scene.autoscale = 0
scene.range = 2.0
scene.forward = (-2/3,-1/3,-2/3)
scene.fov = pi/90.0

drag = 0

while 1:
    if scene.mouse.events:
        m = scene.mouse.getevent()
        if m.drag:
            drag = 1
            obs = None
        elif m.drop:
            drag = 0
        elif m.click:
            if m.pick is s_length:
                if fixtheta:
                    fixtheta = not(fixtheta)
                    s_theta.color = (0.6, 1.0, 0.6)
                fixlength=not(fixlength)
                if fixlength:
                    s_length.color=(0.0, 0.0, 1.0)
                else:
                    s_length.color=(0.6, 0.6, 1.0)
            elif m.pick is s_theta:
                if fixlength:
                    fixlength = not(fixlength)
                    s_length.color=(0.6, 0.6, 1.0)
                fixtheta = not(fixtheta)
                if fixtheta:
                    s_theta.color=(0.0, 1.0, 0.0)
                else:
                    s_theta.color = (0.6, 1.0, 0.6)
    if drag:
        newobs=scene.mouse.project(normal=scene.forward, d=0)

        if newobs and (newobs != obs):
            obs = newobs
            if not fixlength and not fixtheta:

                bvector = norm(obs-scene.forward)
                                        
                b.axis=bvector
            elif fixlength:
                length=1.0
                bvector = length*norm(obs)
                b.axis=bvector
            elif fixtheta:
                length=mag(obs)
                bvector=length*norm(vector(0, .3, 1))
                b.axis=bvector

            cvector=cross(avector,b.axis)
            c.axis=cvector

